document.addEventListener('DOMContentLoaded', () => {
    const sidebar = document.querySelector('.sidebar');
    const rightBar = document.querySelector('.right-bar');
    const overlay = document.querySelector('.overlay');
    const sidebarToggle = document.querySelector('.sidebar-toggle');
    const closeSidebarBtn = document.querySelector('.close-sidebar');
    const rightBarToggle = document.querySelector('.right-bar-toggle');
    const hasDropdowns = document.querySelectorAll('.has-dropdown');

    // Sidebar Toggle
    sidebarToggle.addEventListener('click', () => {
        if (window.innerWidth > 768) {
            sidebar.classList.toggle('mini');
        } else {
            sidebar.classList.add('open');
            overlay.classList.add('visible');
        }
    });

    // Right Bar Toggle
    rightBarToggle.addEventListener('click', () => {
        rightBar.classList.add('open');
        overlay.classList.add('visible');
    });

    function closeAllSidebars() {
        console.log('Closing all sidebars');
        sidebar.classList.remove('open');
        if (rightBar) rightBar.classList.remove('open');
        overlay.classList.remove('visible');
    }

    // Close on Overlay Click (Tap Away)
    overlay.addEventListener('click', () => {
        console.log('Overlay clicked');
        closeAllSidebars();
    });

    if (closeSidebarBtn) {
        closeSidebarBtn.addEventListener('click', closeAllSidebars);
    }

    // Robust Capture-phase listener for mobile tap-away
    document.addEventListener('touchstart', (e) => {
        if (sidebar.classList.contains('open')) {
            const isInside = sidebar.contains(e.target) || (sidebarToggle && sidebarToggle.contains(e.target));
            console.log('Touchstart on open sidebar. Inside:', isInside, 'Target:', e.target);
            if (!isInside) {
                closeAllSidebars();
                // e.preventDefault(); // Might need this if something else re-opens it
            }
        }
    }, true);

    document.addEventListener('mousedown', (e) => {
        if (sidebar.classList.contains('open')) {
            const isInside = sidebar.contains(e.target) || (sidebarToggle && sidebarToggle.contains(e.target));
            console.log('Mousedown on open sidebar. Inside:', isInside, 'Target:', e.target);
            if (!isInside) {
                closeAllSidebars();
            }
        }
    }, true);

    // Dropdown Logic
    hasDropdowns.forEach(dropdown => {
        dropdown.addEventListener('click', (e) => {
            // Only allow toggling dropdowns if sidebar is NOT mini OR if it's hovered
            if (!sidebar.classList.contains('mini') || sidebar.matches(':hover')) {
                dropdown.classList.toggle('open');
            }
        });
    });

    // Active Navigation Highlighting
    const currentPath = window.location.pathname.split('/').pop() || 'index.php';
    const currentHash = window.location.hash;
    const currentFull = currentPath + currentHash;
    const navLinks = document.querySelectorAll('.nav-link');

    // Remove all existing active states first
    navLinks.forEach(link => link.classList.remove('active'));
    document.querySelectorAll('.has-dropdown').forEach(d => d.classList.remove('active-parent', 'open'));

    let matched = false;

    // Try exact full match (path + hash) first
    navLinks.forEach(link => {
        if (matched) return;
        const href = link.getAttribute('href');
        if (href === currentFull) {
            activateLink(link);
            matched = true;
        }
    });

    // Fallback to path match if no exact match (important for index.php vs index.php#)
    if (!matched) {
        navLinks.forEach(link => {
            if (matched) return;
            const href = link.getAttribute('href');
            if (href === currentPath || (currentPath === 'index.php' && href === 'index.php')) {
                activateLink(link);
                matched = true;
            }
        });
    }

    function activateLink(link) {
        link.classList.add('active');
        const parentDropdown = link.closest('.has-dropdown');
        if (parentDropdown) {
            parentDropdown.classList.add('open', 'active-parent');
        }
    }

    // Setup data-titles for mini sidebar hover (fallback if CSS attr not enough)
    navLinks.forEach(link => {
        const text = link.querySelector('span');
        if (text) {
            link.setAttribute('data-title', text.innerText);
        }
    });
});
