<?php
// Default title if not set
if (!isset($page_title)) {
    $page_title = "Central Hub";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title><?php echo $page_title; ?></title>
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <!-- Font Awesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <?php if (isset($extra_css)): ?>
        <?php echo $extra_css; ?>
    <?php endif; ?>

    <!-- Custom CSS -->
    <link rel="stylesheet" href="../master/css/dashboard.css">
</head>
<body>

    <!-- Overlay for mobile navigation -->
    <div class="overlay"></div>

    <!-- Left Sidebar -->
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2 style="font-weight: 700; background: var(--accent-gradient); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">ADMIN DB</h2>
            <button class="close-sidebar mobile-only" style="background: none; border: none; color: white; font-size: 1.25rem; cursor: pointer;">
                <i class="fa-solid fa-xmark"></i>
            </button>
        </div>
        
        <div class="user-profile">
            <div class="user-avatar">
                <i class="fa-solid fa-user"></i>
            </div>
            <div class="user-info">
                <span class="user-name">Ahsan</span>
                <span class="user-role">Administrator</span>
            </div>
            <a href="logout.php" class="logout-btn" title="Logout">
                <i class="fa-solid fa-right-from-bracket"></i>
            </a>
        </div>

        <nav class="nav-links">
            <div class="nav-item">
                <a href="index.php" class="nav-link">
                    <i class="fa-solid fa-gauge"></i>
                    <span>Central Hub</span>
                </a>
            </div>
            
            <div class="nav-item has-dropdown">
                <div class="nav-link">
                    <i class="fa-solid fa-building"></i>
                    <span>Companies</span>
                    <i class="fa-solid fa-chevron-down chevron"></i>
                </div>
                <div class="dropdown-menu">
                    <a href="list.php" class="nav-link"><span>View All</span></a>
                    <a href="index.php#add" class="nav-link"><span>Add New</span></a>
                    <a href="index.php#categories" class="nav-link"><span>Categories</span></a>
                </div>
            </div>

            <div class="nav-item">
                <a href="users.php" class="nav-link">
                    <i class="fa-solid fa-users"></i>
                    <span>Users</span>
                </a>
            </div>

            <div class="nav-item has-dropdown">
                <div class="nav-link">
                    <i class="fa-solid fa-gear"></i>
                    <span>Settings</span>
                    <i class="fa-solid fa-chevron-down chevron"></i>
                </div>
                <div class="dropdown-menu">
                    <a href="profile.php" class="nav-link"><span>Profile</span></a>
                    <a href="account.php" class="nav-link"><span>Account</span></a>
                    <a href="system.php" class="nav-link"><span>System</span></a>
                </div>
            </div>
        </nav>
    </aside>

    <!-- Right bar Toggle (Settings) -->
    <aside class="right-bar">
        <h3>Quick Settings</h3>
        <hr style="border: 0; border-top: 1px solid var(--glass-border); margin: 1.5rem 0;">
        <div style="text-align: center; color: var(--text-secondary); padding: 2rem 1rem;">
            <i class="fa-solid fa-sliders" style="font-size: 2rem; opacity: 0.2; margin-bottom: 1rem; display: block;"></i>
            <p style="font-size: 0.85rem;">Settings are currently empty</p>
        </div>
    </aside>

    <!-- Main Wrapper -->
    <div class="main-wrapper">
        <header class="top-header">
            <div style="display: flex; align-items: center; gap: 1rem; flex: 1;">
                <button class="sidebar-toggle" style="background: none; border: none; color: white; font-size: 1.25rem; cursor: pointer;">
                    <i class="fa-solid fa-bars-staggered"></i>
                </button>
                
                <div class="search-container">
                    <i class="fa-solid fa-magnifying-glass search-icon"></i>
                    <input type="text" placeholder="Search..." class="search-input">
                </div>
            </div>
            
            <div class="header-right">
                <button class="right-bar-toggle" style="background: none; border: none; color: white; font-size: 1.25rem; cursor: pointer;">
                    <i class="fa-solid fa-user-gear"></i>
                </button>
            </div>
        </header>

        <main class="main-content">
