<?php 
$page_title = "Company Details";
include("../master/header.php"); 
?>

    <div class="heading-card">
        <div class="heading-card-header">
            <div>
                <div style="display: flex; align-items: center; gap: 1rem; margin-bottom: 0.5rem;">
                    <span class="badge-glow badge-emerald-glow">
                        <i class="fa-solid fa-circle" style="font-size: 0.5rem;"></i>
                        Active Member
                    </span>
                    <span style="color: rgba(255,255,255,0.6); font-size: 0.9rem;">ID: #CMP-7429</span>
                </div>
                <h1>Tech Nova Solutions</h1>
                <p>Enterprise Software Development & Cloud Infrastructure</p>
            </div>
            <div style="display: flex; gap: 1rem;">
                <a href="list.php" class="add-btn" style="background: rgba(255,255,255,0.1); border: 1px solid var(--glass-border); color: white !important;">
                    <i class="fa-solid fa-arrow-left"></i>
                    Back
                </a>
                <a href="#" class="add-btn" style="background: var(--accent-gradient);">
                    <i class="fa-solid fa-pen-to-square"></i>
                    Edit Profile
                </a>
            </div>
        </div>
    </div>

    <div class="view-container">
        <!-- Sidebar Info -->
        <div class="profile-card">
            <div class="profile-avatar-large">
                <i class="fa-solid fa-building"></i>
            </div>
            <h2 style="color: var(--text-primary); margin-bottom: 0.5rem;">Tech Nova Solutions</h2>
            <p style="color: var(--text-secondary); margin-bottom: 2rem;">Since Oct 2021</p>
            
            <div style="text-align: left;">
                <div class="info-item" style="margin-bottom: 1.5rem;">
                    <label>Primary Contact</label>
                    <span><i class="fa-solid fa-user"></i> Ahsan Khan</span>
                </div>
                <div class="info-item" style="margin-bottom: 1.5rem;">
                    <label>Email Address</label>
                    <span style="color: #3b82f6;"><i class="fa-solid fa-envelope"></i> contact@technova.com</span>
                </div>
                <div class="info-item">
                    <label>Phone Number</label>
                    <span><i class="fa-solid fa-phone"></i> +1 (555) 123-4567</span>
                </div>
            </div>
            
            <hr style="border: 0; border-top: 1px solid var(--glass-border); margin: 2rem 0;">
            
            <div style="display: flex; justify-content: space-around;">
                <a href="#" style="color: var(--text-secondary); font-size: 1.2rem;"><i class="fa-brands fa-linkedin"></i></a>
                <a href="#" style="color: var(--text-secondary); font-size: 1.2rem;"><i class="fa-brands fa-twitter"></i></a>
                <a href="#" style="color: var(--text-secondary); font-size: 1.2rem;"><i class="fa-brands fa-github"></i></a>
                <a href="#" style="color: var(--text-secondary); font-size: 1.2rem;"><i class="fa-solid fa-globe"></i></a>
            </div>
        </div>

        <!-- Main Content -->
        <div class="main-details">
            <div class="info-card">
                <div class="card-title">
                    <i class="fa-solid fa-circle-info"></i>
                    Company Overview
                </div>
                <p style="color: var(--text-secondary); line-height: 1.8; margin-bottom: 0;">
                    Tech Nova Solutions is a leading provider of innovative enterprise software solutions. We specialize in digital transformation, helping businesses leverage cloud infrastructure and AI-driven analytics to optimize their operations. Our commitment to excellence and client-centric approach has made us a trusted partner for Fortune 500 companies worldwide.
                </p>
            </div>

            <div class="info-card">
                <div class="card-title">
                    <i class="fa-solid fa-layer-group"></i>
                    Service Specializations
                </div>
                <div class="info-grid">
                    <div class="info-item">
                        <label>Industry</label>
                        <span><i class="fa-solid fa-microchip"></i> Technology</span>
                    </div>
                    <div class="info-item">
                        <label>Company Size</label>
                        <span><i class="fa-solid fa-users"></i> 500 - 1000 Employees</span>
                    </div>
                    <div class="info-item">
                        <label>Primary Service</label>
                        <span><i class="fa-solid fa-cloud"></i> Cloud Solutions</span>
                    </div>
                    <div class="info-item">
                        <label>Secondary Service</label>
                        <span><i class="fa-solid fa-code"></i> Custom Software</span>
                    </div>
                </div>
            </div>

            <div class="info-card">
                <div class="card-title">
                    <i class="fa-solid fa-location-dot"></i>
                    Headquarters & Branches
                </div>
                <div class="info-grid">
                    <div class="info-item">
                        <label>Address</label>
                        <span>123 Innovation Drive, Silicon Valley, CA 94025</span>
                    </div>
                    <div class="info-item">
                        <label>Region</label>
                        <span>North America</span>
                    </div>
                </div>
            </div>

            <div class="info-card" style="background: linear-gradient(135deg, rgba(59, 130, 246, 0.1) 0%, rgba(30, 41, 59, 0.4) 100%); border-color: rgba(59, 130, 246, 0.2);">
                <div class="card-title">
                    <i class="fa-solid fa-chart-line"></i>
                    Performance Status
                </div>
                <div class="info-grid">
                    <div class="info-item">
                        <label>Account Manager</label>
                        <span><i class="fa-solid fa-user-tie"></i> Sarah Jenkins</span>
                    </div>
                    <div class="info-item">
                        <label>Next Review</label>
                        <span><i class="fa-solid fa-calendar-days"></i> March 15, 2026</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php include("../master/footer.php"); ?>
