<?php 
$page_title = "Company List | Admin Dashboard";
$extra_css = '
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
';

$extra_js = '
    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.7.0.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
    <script src="../master/js/table-init.js"></script>
';

include("../master/header.php"); 
?>

            <div class="heading-card heading-card-emerald">
                <div class="heading-card-header">
                    <div>
                        <h1>Company Management</h1>
                        <p>Manage, search, and export your company data with precision.</p>
                    </div>
                    <a href="add.php" class="add-btn">
                        <i class="fa-solid fa-plus"></i>
                        Add New Company
                    </a>
                </div>
            </div>

            <div class="table-container" style="background: var(--card-bg); backdrop-filter: var(--glass-effect); border: 1px solid var(--glass-border); padding: 1.5rem; border-radius: 12px;">
                <div class="table-responsive">
                    <table id="companyTable" class="display nowrap" style="width:100%">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Sector</th>
                                <th>Email</th>
                                <th>Status</th>
                                <th>Revenue</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php for($i=1; $i<=50; $i++): ?>
                            <tr>
                                <td>#<?php echo 1000 + $i; ?></td>
                                <td style="color: var(--text-primary); font-weight: 500;">Modern Tech Labs <?php echo $i; ?></td>
                                <td>Cloud Services</td>
                                <td>admin@moderntech<?php echo $i; ?>.io</td>
                                <td>
                                    <span style="padding: 0.2rem 0.5rem; border-radius: 4px; font-size: 0.7rem; background: rgba(16, 185, 129, 0.1); color: #10b981;">Active</span>
                                </td>
                                <td>$<?php echo number_format(rand(50000, 1000000)); ?></td>
                                <td>
                                    <div style="display: flex; gap: 0.5rem;">
                                        <i class="fa-solid fa-pen-to-square action-btn" style="color: #3b82f6;"></i>
                                        <i class="fa-solid fa-trash action-btn" style="color: #f43f5e;"></i>
                                    </div>
                                </td>
                            </tr>
                            <?php endfor; ?>
                        </tbody>
                    </table>
                </div>
            </div>

<?php include("../master/footer.php"); ?>
