<?php 
$page_title = "Operations Dashboard";
$extra_css = '
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
    <style>
        /* Custom DataTables Styling for Dark Theme */
        .dataTables_wrapper {
            padding: 1rem;
            color: var(--text-primary);
        }
        .dataTables_filter input {
            background: rgba(255, 255, 255, 0.05) !important;
            border: 1px solid var(--glass-border) !important;
            border-radius: 8px !important;
            color: white !important;
            padding: 0.5rem !important;
        }
        .dataTables_length select {
            background: rgba(255, 255, 255, 0.05) !important;
            border: 1px solid var(--glass-border) !important;
            color: white !important;
            border-radius: 8px !important;
            padding: 4px !important;
        }
        .dt-buttons {
            margin-bottom: 1rem;
        }
        .dt-button {
            background: rgba(255, 255, 255, 0.05) !important;
            border: 1px solid var(--glass-border) !important;
            color: white !important;
            border-radius: 8px !important;
            padding: 0.4rem 0.8rem !important;
            font-size: 0.8rem !important;
            transition: all 0.2s !important;
        }
        .dt-button:hover {
            background: var(--accent-gradient) !important;
            border-color: transparent !important;
        }
        .dataTables_info, .dataTables_paginate {
            margin-top: 1rem;
            color: var(--text-secondary) !important;
        }
        .dataTables_paginate .paginate_button {
            color: var(--text-secondary) !important;
            border-radius: 8px !important;
        }
        .dataTables_paginate .paginate_button.current {
            background: var(--accent-gradient) !important;
            color: white !important;
            border: none !important;
        }
        
        .tab-section-header {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin: 2rem 0 1rem;
            padding: 0 1rem;
        }
        .tab-section-header h3 {
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--text-primary);
            margin: 0;
        }
        .tab-section-header .line {
            flex: 1;
            height: 1px;
            background: linear-gradient(90deg, var(--glass-border), transparent);
        }
        .tab-section-header .badge-count {
            background: rgba(255, 255, 255, 0.05);
            padding: 0.2rem 0.6rem;
            border-radius: 10px;
            font-size: 0.8rem;
            color: var(--text-secondary);
        }

        /* Colorful Tabs Styles */
        .tab-btn.tab-blue.active {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            box-shadow: 0 4px 15px rgba(59, 130, 246, 0.4);
        }
        .tab-btn.tab-indigo.active {
            background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
            box-shadow: 0 4px 15px rgba(99, 102, 241, 0.4);
        }
        .tab-btn.tab-emerald.active {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            box-shadow: 0 4px 15px rgba(16, 185, 129, 0.4);
        }
        .tab-btn.tab-amber.active {
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
            box-shadow: 0 4px 15px rgba(245, 158, 11, 0.4);
        }
        
        /* Non-active hover colors */
        .tab-btn.tab-blue:not(.active):hover { border-color: #3b82f6; color: #3b82f6; }
        .tab-btn.tab-indigo:not(.active):hover { border-color: #6366f1; color: #6366f1; }
        .tab-btn.tab-emerald:not(.active):hover { border-color: #10b981; color: #10b981; }
        .tab-btn.tab-amber:not(.active):hover { border-color: #f59e0b; color: #f59e0b; }
    </style>
';

$extra_js = '
    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.7.0.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
    <script>
        $(document).ready(function() {
            function initTables() {
                $(".dashboard-table").each(function() {
                    if (!$.fn.DataTable.isDataTable(this)) {
                        $(this).DataTable({
                            dom: "Blfrtip",
                            buttons: ["excel", "pdf", "print"],
                            pageLength: 5,
                            lengthMenu: [[5, 10, 25, 50, -1], [5, 10, 25, 50, "All"]],
                            ordering: true,
                            responsive: true,
                            language: {
                                search: "_INPUT_",
                                searchPlaceholder: "Search records..."
                            }
                        });
                    }
                });
            }

            initTables();

            // Adjust columns on tab change
            window.adjustTableColumns = function() {
                $($.fn.dataTable.tables(true)).DataTable().columns.adjust().draw();
            };
        });

        function openTab(evt, tabName) {
            var i, tabContent, tabBtns;
            tabContent = document.getElementsByClassName("tab-content");
            for (i = 0; i < tabContent.length; i++) {
                tabContent[i].style.display = "none";
                tabContent[i].classList.remove("active");
            }
            tabBtns = document.getElementsByClassName("tab-btn");
            for (i = 0; i < tabBtns.length; i++) {
                tabBtns[i].classList.remove("active");
            }
            document.getElementById(tabName).style.display = "block";
            document.getElementById(tabName).classList.add("active");
            evt.currentTarget.classList.add("active");

            // Fix DataTables sizing after tab switch
            if (window.adjustTableColumns) {
                setTimeout(window.adjustTableColumns, 100);
            }
        }
    </script>
';
include("../master/header.php"); 
?>

<div class="heading-card">
    <h1>Operations Dashboard</h1>
    <p>Monitor real-time bookings and service assignments for today and tomorrow.</p>
</div>

<div class="tab-container">
    <div class="tab-header">
        <button class="tab-btn tab-blue active" onclick="openTab(event, 'bookings-today')">
            <i class="fa-solid fa-calendar-day"></i> Bookings Today <span class="count-badge">2</span>
        </button>
        <button class="tab-btn tab-indigo" onclick="openTab(event, 'bookings-tomorrow')">
            <i class="fa-solid fa-calendar-plus"></i> Bookings Tomorrow <span class="count-badge">3</span>
        </button>
        <button class="tab-btn tab-emerald" onclick="openTab(event, 'services-today')">
            <i class="fa-solid fa-bell-concierge"></i> Services Today <span class="count-badge">3</span>
        </button>
        <button class="tab-btn tab-amber" onclick="openTab(event, 'services-tomorrow')">
            <i class="fa-solid fa-clock"></i> Services Tomorrow <span class="count-badge">2</span>
        </button>
    </div>

    <!-- Bookings Today -->
    <div id="bookings-today" class="tab-content active">
        <div class="tab-section-header">
            <h3>Active Bookings</h3>
            <span class="badge-count">2</span>
            <div class="line"></div>
        </div>
        <div class="dashboard-table-container">
            <table class="dashboard-table display nowrap" style="width:100%">
                <thead>
                    <tr>
                        <th>Time</th>
                        <th>Customer</th>
                        <th>Booking ID</th>
                        <th>Package</th>
                        <th>Pick Up</th>
                        <th>Drop Off</th>
                        <th>Price</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>10:30 AM</td>
                        <td>John Smith</td>
                        <td><a href="#" class="booking-id-link">BK-7842</a></td>
                        <td>Jed-Mak</td>
                        <td>Jeddah Airport</td>
                        <td>Voco Hotel Makkah</td>
                        <td>SAR 450</td>
                        <td><span class="status-badge status-confirmed-bg"><i class="fa-solid fa-circle-check"></i> Confirmed</span></td>
                    </tr>
                    <tr>
                        <td>02:15 PM</td>
                        <td>Ahmed Ali</td>
                        <td><a href="#" class="booking-id-link">BK-7910</a></td>
                        <td>Mak Zt</td>
                        <td>Clock Tower</td>
                        <td>Jeddah Marina</td>
                        <td>SAR 320</td>
                        <td><span class="status-badge status-pending-bg"><i class="fa-solid fa-hourglass-half"></i> Pending</span></td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="tab-section-header">
            <h3>Completed & Cancelled</h3>
            <span class="badge-count">2</span>
            <div class="line"></div>
        </div>
        <div class="dashboard-table-container">
            <table class="dashboard-table display nowrap" style="width:100%">
                <thead>
                    <tr>
                        <th>Time</th>
                        <th>Customer</th>
                        <th>Booking ID</th>
                        <th>Package</th>
                        <th>Pick Up</th>
                        <th>Drop Off</th>
                        <th>Price</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>08:30 AM</td>
                        <td>James Walker</td>
                        <td><a href="#" class="booking-id-link">BK-7830</a></td>
                        <td>Mak-Mad</td>
                        <td>Makkah Tower</td>
                        <td>Madinah Station</td>
                        <td>SAR 600</td>
                        <td><span class="status-badge status-completed-bg"><i class="fa-solid fa-flag-checkered"></i> Completed</span></td>
                    </tr>
                    <tr>
                        <td>05:00 PM</td>
                        <td>Maria Garcia</td>
                        <td><a href="#" class="booking-id-link">BK-8005</a></td>
                        <td>Jed-Mad</td>
                        <td>Jeddah Port</td>
                        <td>Knowledge City</td>
                        <td>SAR 950</td>
                        <td><span class="status-badge status-cancelled-bg"><i class="fa-solid fa-ban"></i> Cancelled</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Bookings Tomorrow -->
    <div id="bookings-tomorrow" class="tab-content">
        <div class="tab-section-header">
            <h3>Active Bookings</h3>
            <span class="badge-count">3</span>
            <div class="line"></div>
        </div>
        <div class="dashboard-table-container">
            <table class="dashboard-table display nowrap" style="width:100%">
                <thead>
                    <tr>
                        <th>Time</th>
                        <th>Customer</th>
                        <th>Booking ID</th>
                        <th>Package</th>
                        <th>Pick Up</th>
                        <th>Drop Off</th>
                        <th>Price</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>08:00 AM</td>
                        <td>Sarah Wilson</td>
                        <td><a href="#" class="booking-id-link">BK-8022</a></td>
                        <td>Mak-Mad</td>
                        <td>voco Hotel Makkah</td>
                        <td>Madinah Hilton</td>
                        <td>SAR 850</td>
                        <td><span class="status-badge status-confirmed-bg"><i class="fa-solid fa-circle-check"></i> Confirmed</span></td>
                    </tr>
                    <tr>
                        <td>11:00 AM</td>
                        <td>David Chen</td>
                        <td><a href="#" class="booking-id-link">BK-8045</a></td>
                        <td>Jed-Mak</td>
                        <td>Jeddah Airport</td>
                        <td>Fairmont Makkah</td>
                        <td>SAR 480</td>
                        <td><span class="status-badge status-pending-bg"><i class="fa-solid fa-hourglass-half"></i> Pending</span></td>
                    </tr>
                    <tr>
                        <td>03:45 PM</td>
                        <td>Linda Ross</td>
                        <td><a href="#" class="booking-id-link">BK-8100</a></td>
                        <td>Mak Zt</td>
                        <td>Abraj Al Bait</td>
                        <td>Corniche Jeddah</td>
                        <td>SAR 350</td>
                        <td><span class="status-badge status-confirmed-bg"><i class="fa-solid fa-circle-check"></i> Confirmed</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Services Today -->
    <div id="services-today" class="tab-content">
        <div class="tab-section-header">
            <h3>Active Services</h3>
            <span class="badge-count">3</span>
            <div class="line"></div>
        </div>
        <div class="dashboard-table-container">
            <table class="dashboard-table display nowrap" style="width:100%">
                <thead>
                    <tr>
                        <th>Time</th>
                        <th>ID</th>
                        <th>Customer</th>
                        <th>Service</th>
                        <th>Pickup</th>
                        <th>Remarks</th>
                        <th>Price</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>11:30 AM</td>
                        <td>SRV-105</td>
                        <td>Elite Events</td>
                        <td>Shuttle Svc</td>
                        <td>Expo Center</td>
                        <td>Hourly standby</td>
                        <td>SAR 900</td>
                        <td><span class="status-badge status-confirmed-bg"><i class="fa-solid fa-circle-check"></i> Confirmed</span></td>
                    </tr>
                    <tr>
                        <td>04:00 PM</td>
                        <td>SRV-108</td>
                        <td>Local Tourism</td>
                        <td>Guided Tour</td>
                        <td>Historical Area</td>
                        <td>Multi-language</td>
                        <td>SAR 600</td>
                        <td><span class="status-badge status-pending-bg"><i class="fa-solid fa-hourglass-half"></i> Pending</span></td>
                    </tr>
                    <tr>
                        <td>06:30 PM</td>
                        <td>SRV-110</td>
                        <td>Private Client</td>
                        <td>City Tour</td>
                        <td>Park Hyatt</td>
                        <td>Senior citizens</td>
                        <td>SAR 550</td>
                        <td><span class="status-badge status-confirmed-bg"><i class="fa-solid fa-circle-check"></i> Confirmed</span></td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="tab-section-header">
            <h3>Completed & Cancelled</h3>
            <span class="badge-count">2</span>
            <div class="line"></div>
        </div>
        <div class="dashboard-table-container">
            <table class="dashboard-table display nowrap" style="width:100%">
                <thead>
                    <tr>
                        <th>Time</th>
                        <th>ID</th>
                        <th>Customer</th>
                        <th>Service</th>
                        <th>Pickup</th>
                        <th>Remarks</th>
                        <th>Price</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>09:00 AM</td>
                        <td>SRV-102</td>
                        <td>Global Tech</td>
                        <td>VIP Escort</td>
                        <td>Ritz Carlton</td>
                        <td>2 vehicles required</td>
                        <td>SAR 1,200</td>
                        <td><span class="status-badge status-completed-bg"><i class="fa-solid fa-flag-checkered"></i> Completed</span></td>
                    </tr>
                    <tr>
                        <td>01:00 PM</td>
                        <td>SRV-106</td>
                        <td>Construction X</td>
                        <td>Site Visit</td>
                        <td>Main Office</td>
                        <td>Mandatory PPE</td>
                        <td>SAR 300</td>
                        <td><span class="status-badge status-cancelled-bg"><i class="fa-solid fa-ban"></i> Cancelled</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Services Tomorrow -->
    <div id="services-tomorrow" class="tab-content">
        <div class="tab-section-header">
            <h3>Active Services</h3>
            <span class="badge-count">2</span>
            <div class="line"></div>
        </div>
        <div class="dashboard-table-container">
            <table class="dashboard-table display nowrap" style="width:100%">
                <thead>
                    <tr>
                        <th>Time</th>
                        <th>ID</th>
                        <th>Customer</th>
                        <th>Service</th>
                        <th>Pickup</th>
                        <th>Remarks</th>
                        <th>Price</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>10:00 AM</td>
                        <td>SRV-201</td>
                        <td>Media Group</td>
                        <td>Press Cover</td>
                        <td>Stadium</td>
                        <td>Large equipment</td>
                        <td>SAR 1,500</td>
                        <td><span class="status-badge status-pending-bg"><i class="fa-solid fa-hourglass-half"></i> Pending</span></td>
                    </tr>
                    <tr>
                        <td>02:00 PM</td>
                        <td>SRV-205</td>
                        <td>Corporate HQ</td>
                        <td>Staff Pick</td>
                        <td>Metro Stn</td>
                        <td>Regular route</td>
                        <td>SAR 400</td>
                        <td><span class="status-badge status-confirmed-bg"><i class="fa-solid fa-circle-check"></i> Confirmed</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include("../master/footer.php"); ?>
